//
//  CSApplication.h
//  iDefrag
//
//  Created by Chris Suter on 21/03/07.
//  Copyright 2007 Coriolis Systems Ltd. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface CSApplication : NSApplication {
  BOOL processingEvent;
  NSMutableArray *performQueue;
}
@end

@interface NSObject (CSSafePerform)
- (void)safelyPerformSelectorOnMainThread:(SEL)selector
			       withObject:(id)arg;
- (void)safelyPerformSelector:(SEL)selector
		   withObject:(id)arg
		   afterDelay:(NSTimeInterval)delay;
@end

@interface NSApplication (CSSafePerform)
- (void)safelyPerformSelectorOnMainThread:(SEL)selector 
				   target:(id)self
			       withObject:(id)arg;
- (void)safelyPerformSelector:(SEL)selector
		       target:(id)target
		   withObject:(id)arg
		   afterDelay:(NSTimeInterval)delay;
@end

